﻿var SNMP_TRAP_NUM = 3;
var NUM_DEV_CARD = 4;
var CardIPChangeFlag = false;
var language;
var rowNum;
var scrambleIpEnable;

var ctrlIpAddr = new Array(5);
var QAM = 1;
var TYPE_518B = 2;

$(document).ready(function()
{
	//用户权限，设置按钮隐藏或者显示
	var apply;
	apply = document.getElementById("applyBtn1");
	applyDispay(parent.group, apply);
	
	language = $("#language").val();
	
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	
	getLocalNetParam();
	
	$("#scrambleIpEnable").click(function()
	{
		EnableApply("applyBtn1");
		if($(this).prop("checked") == true)
		{
			scrambleIpEnable = 1;
		}
		else
		{
			scrambleIpEnable = 0;
		}
		enableScrambleIpParam();
	});
});

function enableScrambleIpParam()
{
	if(scrambleIpEnable == 0)
	{
		$("#scrambleIpEnable").prop("checked", false);
		$("#scrambleIp").attr("disabled", true);
		$("#scrambleMask").attr("disabled", true);
		$("#scrambleGateway").attr("disabled", true);
	}
	else
	{
		$("#scrambleIpEnable").prop("checked", true);
		$("#scrambleIp").attr("disabled", false);
		$("#scrambleMask").attr("disabled", false);
		$("#scrambleGateway").attr("disabled", false);
	}
}

function MgmtPortDisplay()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=18&cmd=1&language=" + language + "&getIpNetwork=1";
	var response;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, -bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			var intData = 0;
			var cellCount = 0;
			var ifData = response.split("&");
			var i,id;
			var cnt = 0;
			
			document.getElementById("slot_name").innerHTML = ifData[cellCount++];
			
			/* Main Board - IP Address */	
			document.getElementById("ip_addr").value = ifData[cellCount];
			ctrlIpAddr[cnt++] = ifData[cellCount];
			
			/* Main Board - Subnet Mask */
			cellCount++;			
			document.getElementById("subnet_mask").value = ifData[cellCount];

			/* Main Board - MAC Address */
			cellCount++;
			document.getElementById("mac_addr").innerHTML = ifData[cellCount];
			
			/* Main Board - Default Gateway */
			cellCount++;
			document.getElementById("default_gateway").value = ifData[cellCount];
			
			for(i = 0; i < SNMP_TRAP_NUM; i++)
			{
				id = i + 1;
				/* Main Board - SNMP Trap Address */
				cellCount++;
				document.getElementById("snmp_addr" + id).value = ifData[cellCount];				
			}			
			document.body.style.cursor="auto";
			window.status = "Done";
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	if((parent.deviceAttr == QAM) || (parent.deviceAttr == TYPE_518B))
	{
		$("#scrambleDiv").hide();
		$("#subNetLi").hide();
		$("#lastLi").attr("class", "last_selected");
	}
	else
	{
		$("#scrambleDiv").show();
		$("#subNetLi").show();
		$("#lastLi").attr("class", "last_no_selected");
	}
	return true;
}

function getScrambleNetParam()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=18&cmd=1&language=" + language + "&getScIpNetwork=1";
	var response;
	var rowData;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, -bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			rowData = response.split("&");
			scrambleIpEnable = rowData[0];
			enableScrambleIpParam();
			$("#scrambleIp").val(rowData[1]);
			$("#scrambleMask").val(rowData[2]);
			$("#scrambleGateway").val(rowData[3]);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function getPrivateNetParam()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=18&cmd=1&language=" + language + "&getLocalNetPara=1";
	var response;
	var rowData;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, -bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			rowData = response.split("&");
			virtualEnableFlag = rowData[0];
			$("#virtualServerEnable").val(rowData[0]);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function refreshLocalNetParam()
{
	getLocalNetParam();
}

function getLocalNetParam()
{
	DisableApply("applyBtn1");
	
	MgmtPortDisplay();
	getScrambleNetParam();
	getPrivateNetParam();
	
	CardIPChangeFlag = false;
}

function checkIpAddr(comp)
{
	if(Validate_IPAddress(comp.val()) == false)
	{		
		if(language == 0)
		{
			alert("Invalid IP Address. Please input a valid IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入正确的IP地址。");
		}
		setTimeout(function() {comp.focus()}, 50);
		comp.select();
		return false;
	}
	return true;
}

function validateIP(obj)
{	
	if(Validate_IPAddress(obj.val()) == false)
	{		
		if(language == 0)
		{
			alert("Invalid IP Address. Please input a valid IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入正确的IP地址。");
		}
		setTimeout(function() {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if(IPCompare(obj.val(), $("#scrambleIp").val()))
	{
		if(language == 0)
		{
			alert("The ip address of mainboard and scramble ip Address should not be the same!");
		}
		else
		{
			alert("主板和加扰的IP地址不能一样！");
		}
		setTimeout(function() {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function validateScrambleIP(obj)
{	
	if(Validate_IPAddress(obj.val()) == false)
	{		
		if(language == 0)
		{
			alert("Invalid Scramble IP Address. Please input a valid Scramble IP Address.");
		}
		else
		{
			alert("无效的加扰IP地址，请输入正确的加扰IP地址。");
		}
		setTimeout(function() {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if(IPCompare(obj.val(), $("#ip_addr").val()))
	{
		if(language == 0)
		{
			alert("The ip address of mainboard and scramble ip Address should not be the same!");
		}
		else
		{
			alert("主板和加扰的IP地址不能一样！");
		}
		setTimeout(function() {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	return true;
}
function validateMask(obj)
{
	if(Valid_Mask(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid Subnet Mask. Please input a valid Subnet Mask.");
		}
		else
		{
			alert("无效的子网掩码，请输入正确的子网掩码。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function validateGateway(obj)
{
	if(Validate_IP_Format(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid IP Address. Please input a valid default Gateway IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入正确的默认网关IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}
function validatePort(obj)
{
	if(validateNumber(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for UDP Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的UDP端口。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((obj.val() < 0) || (obj.val() > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Port is 0 - 65535.");
		}
		else
		{
			alert("端口号的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;  
}
function validateTrapAddr(obj)
{
	if(Validate_IP_Format(obj.val()) == false)
	{		
		if(language == 0)
		{
			alert("Invalid SNMP Trap Address. Please input a valid SNMP Trap Address.");
		}
		else
		{
			alert("无效的SNMP Trap地址，请输入正确的SNMP Trap地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}
function validateScrambleIp(obj)
{
	if(Validate_IP_Format(obj.val()) == false)
	{		
		if(language == 0)
		{
			alert("Invalid Scramble IP Address. Please input a valid Scramble IP Address.");
		}
		else
		{
			alert("无效的加扰IP地址，请输入正确加扰IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}
	
function ValidateAllIP()
{
	var obj;
	var i,j,id;
	var ip_value, mask_value, gw_value;
	
	ip_value = document.getElementById("ip_addr").value;
	mask_value = document.getElementById("subnet_mask").value;
	gw_value = document.getElementById("default_gateway").value;

	obj = $("#ip_addr");
	if(!checkIpAddr(obj))
	{
		return false;
	}
		
	obj = $("#subnet_mask");
	if(validateMask(obj) == false)
	{
		return false;
	}
	if(Validate_Subnet(ip_value, mask_value) == false)
	{
		if(language == 0)
		{
			alert("Subnet Mask and IP Address do not match .Please enter a valid Subnet Mask.")
		}
		else
		{
			alert("子网掩码和IP地址不相符，请输入一个有效的子网掩码。")
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if($("#ip_addr").val()==$("#default_gateway").val()){
		if(language == 0)
		{
			alert("IP address and gateway should not be the same! ")
		}
		else
		{
			alert("IP地址不能与默认网关相同。")
		}
			return false;
	}
	obj = $("#default_gateway");
	if(validateGateway(obj) == false)
	{
		return false;
	}
	if(gw_value != "0.0.0.0")
	{
		if(Valid_Gateway(ip_value, mask_value, gw_value) == false)
		{
			if(language == 0)
			{
				alert("Gateway and IP Address do not fall in the same network .Please enter a valid Gateway.")
			}
			else
			{
				alert("网关和IP地址没有落到同一网段，请输入一个有效的网关。")
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	
	for(i = 0; i < SNMP_TRAP_NUM; i++)
	{
		id = i + 1;
		obj = $("#snmp_addr" + id);
		if(validateTrapAddr(obj) == false)
		{
			return false;
		}
	}
	
	return true;	
}
function validateScrambleParam()
{
	if(scrambleIpEnable == 0)
	{
		return true;
	}
	var obj;
	var i,j,id;
	var ip_value, mask_value, gw_value;
	
	ip_value = document.getElementById("scrambleIp").value;
	mask_value = document.getElementById("scrambleMask").value;
	gw_value = document.getElementById("scrambleGateway").value;

	obj = $("#scrambleIp");
	if(!validateScrambleIp(obj))
	{
		return false;
	}
		
	obj = $("#scrambleMask");
	if(validateMask(obj) == false)
	{
		return false;
	}
	if(Validate_Subnet(ip_value, mask_value) == false)
	{
		if(language == 0)
		{
			alert("Subnet Mask and IP Address do not match .Please enter a valid Subnet Mask.")
		}
		else
		{
			alert("子网掩码和IP地址不相符，请输入一个有效的子网掩码。")
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#scrambleGateway");
	if(validateGateway(obj) == false)
	{
		return false;
	}
	if(gw_value != "0.0.0.0")
	{
		if(Valid_Gateway(ip_value, mask_value, gw_value) == false)
		{
			if(language == 0)
			{
				alert("Gateway and IP Address do not fall in the same network .Please enter a valid Gateway.")
			}
			else
			{
				alert("网关和IP地址没有落到同一网段，请输入一个有效的网关。")
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	return true;
}

function CardIPChange()
{
	CardIPChangeFlag = true;
}

function PortConfigThroDataBase()
{
	var i,id;
	/* Generate params to POST from the from controls*/
	var params = "type=18&cmd=2&";
	
	var ip_addr = document.getElementById("ip_addr").value;
	params = params + "ip_addr=" + ip_addr + "&";
	
	var subnet_mask = document.getElementById("subnet_mask").value;
	params = params + "subnet_mask=" + subnet_mask + "&";
	
	var default_gateway = document.getElementById("default_gateway").value;
	params = params + "default_gateway=" + default_gateway + "&";
	
	for(i = 0; i < SNMP_TRAP_NUM; i++)
	{
		id = i + 1;
		var snmp_addr = document.getElementById("snmp_addr" + id).value;
		params = params + "snmp_addr" + id + "=" + snmp_addr + "&";
	}
	
	/* Generate virtual network parammeters*/
	params = params + "scrambleIpEnable=" + scrambleIpEnable + "&";
	params = params + "scrambleIp=" + $("#scrambleIp").val() + "&";
	params = params + "scrambleSubnet=" + $("#scrambleMask").val() + "&";
	params = params + "scrambleGateway=" + $("#scrambleGateway").val() + "&";
	
	/* Generate virtual network parammeters*/
	params = params + "virtualServerEnable=" + $("#virtualServerEnable").val();


	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("System IP network configuration updated successfully.");
			}
			else
			{
				alert("系统IP参数已设置成功。");
			}
		/*	if($("#virtualServerEnable").val() != virtualEnableFlag)
			{
				if(language == 0)
				{
					alert("Virtual Server Configurations changed.The new configurations will take effect after rebooting!");
				}
				else
				{
					alert("虚拟服务器设置发生改变，需要重启后方可生效！");
				}
			}*/
			if(CardIPChangeFlag == true)
			{
				var url;
				if(language == 0)
				{
					url = "../asp/main.asp?nodeId=" + parent.curTree.getSelectedNodes()[0].id;
				}
				else
				{
					url = "../asp/main_cn.asp?nodeId=" + parent.curTree.getSelectedNodes()[0].id;
				}
				window.parent.location.replace(url);
			}
			else
			{
				getLocalNetParam();
			}
		}
	}
	xmlhttp.send(params)
	return;
}

function SetPortConfiguration()
{
	DisableApply("applyBtn1");
	document.body.style.cursor = "wait";
	window.status = "Applying settings, please wait...";
	var returnFlag;
	
	if(ValidateAllIP() == true)
	{
		if((parent.deviceAttr != QAM) && (parent.deviceAttr != TYPE_518B))
		{
			if(validateScrambleParam() == true)
			{
				if(IPCompare($("#ip_addr").val(), $("#scrambleIp").val()))
				{
					if(language == 0)
					{
						alert("The ip address of mainboard and scramble ip address should not be the same!");
					}
					else
					{
						alert("主板和加扰的IP地址不能一样！");
					}
					window.status = "Done";
					document.body.style.cursor = "auto";
					EnableApply("applyBtn1");
					return false;
				}
				PortConfigThroDataBase();
			}
		}
		else
		{
			PortConfigThroDataBase();
		}					
	}
	else
	{
		window.status = "Done";
		document.body.style.cursor = "auto";
		EnableApply("applyBtn1");
		return false;
	}
}
